# Generated by Django 4.1.3 on 2022-11-30 17:45

from decimal import Decimal
import dictionary.models.author
import dictionary.models.images
import dictionary.models.managers.author
import dictionary.utils.validators
from django.conf import settings
import django.contrib.auth.models
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import uuid


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("flatpages", "0001_initial"),
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="Author",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                ("last_login", models.DateTimeField(blank=True, null=True, verbose_name="last login")),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text="Designates that this user has all permissions without explicitly assigning them.",
                        verbose_name="superuser status",
                    ),
                ),
                ("first_name", models.CharField(blank=True, max_length=150, verbose_name="first name")),
                ("last_name", models.CharField(blank=True, max_length=150, verbose_name="last name")),
                (
                    "is_staff",
                    models.BooleanField(
                        default=False,
                        help_text="Designates whether the user can log into this admin site.",
                        verbose_name="staff status",
                    ),
                ),
                ("date_joined", models.DateTimeField(default=django.utils.timezone.now, verbose_name="date joined")),
                (
                    "username",
                    models.CharField(
                        error_messages={"unique": "this nickname is already taken"},
                        help_text="the nickname that will represent you in the site. can be 3-35 characters long, can include only letters, numbers and spaces",
                        max_length=35,
                        unique=True,
                        validators=[
                            dictionary.utils.validators.validate_username_partial,
                            dictionary.models.author.AuthorNickValidator(),
                            django.core.validators.MinLengthValidator(3, "this nickname is too tiny"),
                        ],
                        verbose_name="nickname",
                    ),
                ),
                ("slug", models.SlugField(editable=False, max_length=35, unique=True)),
                ("email", models.EmailField(max_length=254, unique=True, verbose_name="e-mail")),
                ("is_active", models.BooleanField(default=False, verbose_name="active")),
                ("is_novice", models.BooleanField(db_index=True, default=True, verbose_name="Novice status")),
                (
                    "application_status",
                    models.CharField(
                        choices=[
                            ("PN", "in novice list"),
                            ("OH", "waiting for first ten entries"),
                            ("AP", "authorship approved"),
                        ],
                        default="OH",
                        max_length=2,
                        verbose_name="Application status",
                    ),
                ),
                (
                    "application_date",
                    models.DateTimeField(blank=True, default=None, null=True, verbose_name="Application date"),
                ),
                (
                    "last_activity",
                    models.DateTimeField(blank=True, default=None, null=True, verbose_name="Last activity as novice"),
                ),
                (
                    "queue_priority",
                    models.PositiveSmallIntegerField(
                        default=0,
                        help_text="Novices with high priority are more likely to appear on the top of the novice list.",
                        verbose_name="Queue priority",
                    ),
                ),
                (
                    "suspended_until",
                    models.DateTimeField(blank=True, default=None, null=True, verbose_name="Suspended until"),
                ),
                ("is_frozen", models.BooleanField(default=False, verbose_name="Frozen status")),
                ("is_private", models.BooleanField(default=False, verbose_name="Anonymous status")),
                ("allow_uncategorized", models.BooleanField(default=True)),
                ("birth_date", models.DateField(blank=True, null=True, verbose_name="Birth date")),
                (
                    "gender",
                    models.CharField(
                        choices=[("MN", "male"), ("WM", "female"), ("OT", "other"), ("NO", "forget it")],
                        default="NO",
                        max_length=2,
                        verbose_name="Gender",
                    ),
                ),
                (
                    "entries_per_page",
                    models.IntegerField(choices=[(10, "10"), (30, "30"), (50, "50"), (100, "100")], default=10),
                ),
                (
                    "topics_per_page",
                    models.IntegerField(choices=[(30, "30"), (50, "50"), (75, "75"), (100, "100")], default=50),
                ),
                (
                    "message_preference",
                    models.CharField(
                        choices=[
                            ("DS", "nobody"),
                            ("AU", "authors and novices"),
                            ("AO", "authors"),
                            ("FO", "people who i follow"),
                        ],
                        default="AU",
                        max_length=2,
                    ),
                ),
                ("allow_receipts", models.BooleanField(default=True)),
                ("allow_site_announcements", models.BooleanField(default=True)),
                (
                    "theme",
                    models.CharField(choices=[("light", "Light"), ("dark", "Dark")], default="light", max_length=10),
                ),
                (
                    "karma",
                    models.DecimalField(
                        decimal_places=2, default=Decimal("0"), max_digits=7, verbose_name="Karma points"
                    ),
                ),
                ("announcement_read", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "verbose_name": "author",
                "verbose_name_plural": "authors",
                "permissions": (
                    ("can_activate_user", "Can access to the novice list"),
                    ("suspend_user", "Can suspend users"),
                    ("can_clear_cache", "Can clear cache"),
                    ("can_comment", "Can comment on entries"),
                    ("can_suggest_categories", "Can suggest categories for topics"),
                ),
            },
            managers=[
                ("objects", django.contrib.auth.models.UserManager()),
                ("objects_accessible", dictionary.models.managers.author.AuthorManagerAccessible()),
                ("in_novice_list", dictionary.models.managers.author.InNoviceList()),
            ],
        ),
        migrations.CreateModel(
            name="Badge",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=36, verbose_name="Name")),
                ("description", models.TextField(blank=True, verbose_name="Description")),
                (
                    "url",
                    models.URLField(
                        blank=True,
                        help_text="The link to follow when users click the badge. If no link is provided, related topic will be used.",
                        verbose_name="Link",
                    ),
                ),
            ],
            options={
                "verbose_name": "badge",
                "verbose_name_plural": "badges",
            },
        ),
        migrations.CreateModel(
            name="Category",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "name",
                    models.CharField(
                        max_length=24,
                        unique=True,
                        validators=[dictionary.utils.validators.validate_category_name],
                        verbose_name="Name",
                    ),
                ),
                ("slug", models.SlugField(editable=False)),
                ("description", models.TextField(blank=True, verbose_name="Description")),
                (
                    "is_pseudo",
                    models.BooleanField(
                        default=False,
                        help_text="Pseudo channels cannot be browsed by the users but can be assigned to the topics. You can add these channels to popular exclusions.",
                        verbose_name="Pseudo channel",
                    ),
                ),
                (
                    "is_default",
                    models.BooleanField(
                        default=True,
                        help_text="When checked, this channel will be present in the following channels of newly registered users. (Pseudo channels are excluded.)",
                        verbose_name="Default",
                    ),
                ),
                ("weight", models.SmallIntegerField(default=0, verbose_name="Weight")),
            ],
            options={
                "verbose_name": "channel",
                "verbose_name_plural": "channels",
                "ordering": ["-weight"],
            },
            managers=[
                ("objects_all", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="Entry",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "content",
                    models.TextField(
                        validators=[dictionary.utils.validators.validate_user_text], verbose_name="Content"
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True, db_index=True, verbose_name="Date created")),
                ("date_edited", models.DateTimeField(blank=True, default=None, null=True, verbose_name="Date edited")),
                (
                    "vote_rate",
                    models.DecimalField(decimal_places=2, default=Decimal("0"), max_digits=7, verbose_name="Vote rate"),
                ),
                ("is_draft", models.BooleanField(db_index=True, default=False, verbose_name="Draft status")),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name="Author"
                    ),
                ),
            ],
            options={
                "verbose_name": "entry",
                "verbose_name_plural": "entries",
                "ordering": ["date_created"],
            },
            managers=[
                ("objects_all", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="ExternalURL",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=64, verbose_name="Name")),
                ("url", models.URLField(verbose_name="Link")),
                ("weight", models.PositiveSmallIntegerField(default=0, verbose_name="Weight")),
            ],
            options={
                "verbose_name": "external url",
                "verbose_name_plural": "external urls",
                "ordering": ("-weight", "name"),
            },
        ),
        migrations.CreateModel(
            name="GeneralReport",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("reporter_email", models.EmailField(max_length=254, verbose_name="e-mail")),
                (
                    "category",
                    models.CharField(
                        choices=[("CNT", "about the some content published"), ("ETC", "about other subjects")],
                        default="CNT",
                        max_length=3,
                        verbose_name="category",
                    ),
                ),
                ("subject", models.CharField(max_length=160, verbose_name="Subject")),
                ("content", models.TextField(verbose_name="Content")),
                (
                    "is_open",
                    models.BooleanField(
                        default=True,
                        help_text="Indicates the current status of the report.",
                        verbose_name="Report is open",
                    ),
                ),
                ("key", models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                (
                    "is_verified",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether this report has been verified by e-mail",
                        verbose_name="Verified",
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True, verbose_name="Date created")),
                ("date_verified", models.DateTimeField(null=True, verbose_name="Date verified")),
            ],
            options={
                "verbose_name": "report",
                "verbose_name_plural": "reports",
            },
        ),
        migrations.CreateModel(
            name="MetaFlatPage",
            fields=[
                (
                    "flatpage_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="flatpages.flatpage",
                    ),
                ),
                (
                    "html_only",
                    models.BooleanField(
                        default=False,
                        help_text="Check this to only use HTML, otherwise you can use entry formatting options.",
                        verbose_name="Allow HTML",
                    ),
                ),
                ("weight", models.PositiveSmallIntegerField(default=0, verbose_name="Weight")),
            ],
            options={
                "verbose_name": "flat page",
                "verbose_name_plural": "flat pages",
                "ordering": ("-weight", "url"),
            },
            bases=("flatpages.flatpage",),
        ),
        migrations.CreateModel(
            name="Topic",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "title",
                    models.CharField(
                        db_index=True,
                        help_text="In order to change the definition of the topic after it has been created, you need to use topic moving feature.",
                        max_length=50,
                        unique=True,
                        validators=[dictionary.utils.validators.validate_topic_title],
                        verbose_name="Definition",
                    ),
                ),
                ("slug", models.SlugField(editable=False, max_length=96, unique=True)),
                (
                    "allow_suggestions",
                    models.BooleanField(
                        default=True,
                        help_text="When checked, users will be able to suggest channels to this topic.",
                        verbose_name="Allow suggestions",
                    ),
                ),
                ("media", models.TextField(blank=True, verbose_name="Media links")),
                (
                    "is_banned",
                    models.BooleanField(
                        default=False,
                        help_text="Check this if you want to hinder authors and novices from entering new entries to this topic.",
                        verbose_name="Prohibited",
                    ),
                ),
                (
                    "is_censored",
                    models.BooleanField(
                        default=False,
                        help_text="Check this if you don't want this topic to appear in in-site searches and <strong>public</strong> topic lists.",
                        verbose_name="Censored",
                    ),
                ),
                (
                    "is_pinned",
                    models.BooleanField(
                        default=False,
                        help_text="Check this if you want this topic to be pinned in popular topics.<br>The topic needs to have at least one entry.",
                        verbose_name="Pinned",
                    ),
                ),
                (
                    "is_ama",
                    models.BooleanField(
                        default=False,
                        help_text="If checked, comments will be visible in this topic. Authorized users will be able to comment on entries.",
                        verbose_name="Ask me anything",
                    ),
                ),
                (
                    "date_created",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="<i>Might not always correspond to first entry.</i>",
                        verbose_name="Date created",
                    ),
                ),
                ("category", models.ManyToManyField(blank=True, to="dictionary.category", verbose_name="Channels")),
                (
                    "created_by",
                    models.ForeignKey(
                        editable=False,
                        help_text="The author or novice who entered the first entry for this topic publicly.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="First user to write an entry",
                    ),
                ),
                (
                    "mirrors",
                    models.ManyToManyField(
                        blank=True,
                        help_text="<p style='color: #ba2121'><b>Warning!</b> The topics that you enter will automatically get related disambiguations. For this reason you should be working on a main topic that you selected.<br> Removing a topic from will cause the removal of <b>ALL</b> disambiguations, so you should note down the topics that you don't want to be removed to add them later.</p>",
                        to="dictionary.topic",
                        verbose_name="Title disambiguation",
                    ),
                ),
            ],
            options={
                "verbose_name": "topic",
                "verbose_name_plural": "topics",
                "permissions": (("move_topic", "Can move topics"),),
            },
        ),
        migrations.CreateModel(
            name="Wish",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "hint",
                    models.TextField(
                        blank=True, validators=[dictionary.utils.validators.validate_user_text], verbose_name="Hint"
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True, verbose_name="Date created")),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="wishes",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Author",
                    ),
                ),
                (
                    "topic",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="wishes",
                        to="dictionary.topic",
                        verbose_name="Topic",
                    ),
                ),
            ],
            options={
                "verbose_name": "wish",
                "verbose_name_plural": "wishes",
                "ordering": ("-date_created",),
            },
        ),
        migrations.CreateModel(
            name="UserVerification",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("verification_token", models.CharField(max_length=128)),
                ("new_email", models.EmailField(blank=True, max_length=254)),
                ("expiration_date", models.DateTimeField()),
                ("author", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name="UpvotedEntries",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("author", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ("entry", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="dictionary.entry")),
            ],
        ),
        migrations.CreateModel(
            name="TopicFollowing",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("read_at", models.DateTimeField(auto_now_add=True)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("author", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ("topic", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="dictionary.topic")),
            ],
        ),
        migrations.CreateModel(
            name="Suggestion",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "direction",
                    models.SmallIntegerField(choices=[(1, "Positive"), (-1, "Negative")], verbose_name="Direction"),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True, verbose_name="Date created")),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name="Author"
                    ),
                ),
                (
                    "category",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="dictionary.category",
                        verbose_name="Channel",
                    ),
                ),
                (
                    "topic",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="category_suggestions",
                        to="dictionary.topic",
                        verbose_name="Topic",
                    ),
                ),
            ],
            options={
                "verbose_name": "suggestion",
                "verbose_name_plural": "suggestions",
            },
        ),
        migrations.CreateModel(
            name="PairedSession",
            fields=[
                (
                    "session_key",
                    models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name="session key"),
                ),
                ("session_data", models.TextField(verbose_name="session data")),
                ("expire_date", models.DateTimeField(db_index=True, verbose_name="expire date")),
                (
                    "user",
                    models.ForeignKey(
                        null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "verbose_name": "session",
                "verbose_name_plural": "sessions",
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Message",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("body", models.TextField(validators=[dictionary.utils.validators.validate_user_text])),
                ("sent_at", models.DateTimeField(auto_now_add=True)),
                ("read_at", models.DateTimeField(editable=False, null=True)),
                ("has_receipt", models.BooleanField(default=True)),
                (
                    "recipient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="+", to=settings.AUTH_USER_MODEL
                    ),
                ),
                (
                    "sender",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="+", to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "ordering": ["sent_at"],
                "get_latest_by": ("sent_at",),
            },
        ),
        migrations.CreateModel(
            name="Memento",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("body", models.TextField(blank=True)),
                ("holder", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                (
                    "patient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="+", to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Image",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "file",
                    models.ImageField(upload_to=dictionary.models.images.user_directory_path, verbose_name="File"),
                ),
                ("slug", models.SlugField(default=dictionary.models.images.image_slug, editable=False, unique=True)),
                ("is_deleted", models.BooleanField(default=False, verbose_name="Unpublished")),
                ("date_created", models.DateTimeField(auto_now_add=True, verbose_name="Date created")),
                (
                    "author",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Author",
                    ),
                ),
            ],
            options={
                "verbose_name": "image",
                "verbose_name_plural": "images",
            },
        ),
        migrations.CreateModel(
            name="EntryFavorites",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("author", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ("entry", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="dictionary.entry")),
            ],
        ),
        migrations.AddField(
            model_name="entry",
            name="topic",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="entries",
                to="dictionary.topic",
                verbose_name="Topic",
            ),
        ),
        migrations.CreateModel(
            name="DownvotedEntries",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("author", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ("entry", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="dictionary.entry")),
            ],
        ),
        migrations.CreateModel(
            name="ConversationArchive",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("target", models.CharField(max_length=35)),
                ("slug", models.SlugField()),
                ("messages", models.TextField()),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("holder", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                "ordering": ("-date_created",),
            },
        ),
        migrations.CreateModel(
            name="Conversation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                (
                    "holder",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="conversations",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                ("messages", models.ManyToManyField(to="dictionary.message")),
                (
                    "target",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="targeted_conversations",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Comment",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "content",
                    models.TextField(
                        validators=[dictionary.utils.validators.validate_user_text], verbose_name="Content"
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True, verbose_name="Date created")),
                ("date_edited", models.DateTimeField(editable=False, null=True, verbose_name="Date edited")),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Author",
                    ),
                ),
                ("downvoted_by", models.ManyToManyField(related_name="+", to=settings.AUTH_USER_MODEL)),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="comments", to="dictionary.entry"
                    ),
                ),
                ("upvoted_by", models.ManyToManyField(related_name="+", to=settings.AUTH_USER_MODEL)),
            ],
            options={
                "verbose_name": "comment",
                "verbose_name_plural": "comments",
            },
        ),
        migrations.CreateModel(
            name="BackUp",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("file", models.FileField(upload_to=dictionary.models.author.user_directory_backup)),
                ("is_ready", models.BooleanField(default=False)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("author", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name="Announcement",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=254, verbose_name="Title")),
                ("content", models.TextField(verbose_name="Content")),
                ("slug", models.SlugField(editable=False)),
                (
                    "html_only",
                    models.BooleanField(
                        default=False,
                        help_text="Check this to only use HTML, otherwise you can use entry formatting options.",
                        verbose_name="Allow HTML",
                    ),
                ),
                (
                    "notify",
                    models.BooleanField(
                        default=False,
                        help_text="When checked, users will get a notification when the announcement gets released.",
                        verbose_name="Notify users",
                    ),
                ),
                ("date_edited", models.DateTimeField(editable=False, null=True)),
                (
                    "date_created",
                    models.DateTimeField(
                        db_index=True,
                        help_text="You can set future dates for the publication date.",
                        verbose_name="Publication date",
                    ),
                ),
                (
                    "discussion",
                    models.ForeignKey(
                        blank=True,
                        help_text="Optional. The topic where the users will be discussing this announcement.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="dictionary.topic",
                        verbose_name="Discussion topic",
                    ),
                ),
            ],
            options={
                "verbose_name": "announcement",
                "verbose_name_plural": "announcements",
            },
        ),
        migrations.CreateModel(
            name="AccountTerminationQueue",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "state",
                    models.CharField(
                        choices=[
                            ("NT", "delete account completely"),
                            ("LE", "delete account with legacy"),
                            ("FZ", "freeze account"),
                        ],
                        default="FZ",
                        max_length=2,
                        verbose_name="last words?",
                    ),
                ),
                ("termination_date", models.DateTimeField(editable=False, null=True)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                (
                    "author",
                    models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
                ),
            ],
        ),
        migrations.AddField(
            model_name="author",
            name="badges",
            field=models.ManyToManyField(blank=True, to="dictionary.badge", verbose_name="Badges"),
        ),
        migrations.AddField(
            model_name="author",
            name="blocked",
            field=models.ManyToManyField(blank=True, related_name="blocked_by", to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name="author",
            name="downvoted_entries",
            field=models.ManyToManyField(
                blank=True, related_name="downvoted_by", through="dictionary.DownvotedEntries", to="dictionary.entry"
            ),
        ),
        migrations.AddField(
            model_name="author",
            name="favorite_entries",
            field=models.ManyToManyField(
                blank=True, related_name="favorited_by", through="dictionary.EntryFavorites", to="dictionary.entry"
            ),
        ),
        migrations.AddField(
            model_name="author",
            name="following",
            field=models.ManyToManyField(blank=True, related_name="+", to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name="author",
            name="following_categories",
            field=models.ManyToManyField(blank=True, to="dictionary.category"),
        ),
        migrations.AddField(
            model_name="author",
            name="following_topics",
            field=models.ManyToManyField(
                blank=True, related_name="followers", through="dictionary.TopicFollowing", to="dictionary.topic"
            ),
        ),
        migrations.AddField(
            model_name="author",
            name="groups",
            field=models.ManyToManyField(
                blank=True,
                help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                related_name="user_set",
                related_query_name="user",
                to="auth.group",
                verbose_name="groups",
            ),
        ),
        migrations.AddField(
            model_name="author",
            name="pinned_entry",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="dictionary.entry",
            ),
        ),
        migrations.AddField(
            model_name="author",
            name="upvoted_entries",
            field=models.ManyToManyField(
                blank=True, related_name="upvoted_by", through="dictionary.UpvotedEntries", to="dictionary.entry"
            ),
        ),
        migrations.AddField(
            model_name="author",
            name="user_permissions",
            field=models.ManyToManyField(
                blank=True,
                help_text="Specific permissions for this user.",
                related_name="user_set",
                related_query_name="user",
                to="auth.permission",
                verbose_name="user permissions",
            ),
        ),
        migrations.AddConstraint(
            model_name="suggestion",
            constraint=models.UniqueConstraint(
                fields=("author", "topic", "category"), name="unique_category_suggestion"
            ),
        ),
        migrations.AddConstraint(
            model_name="memento",
            constraint=models.UniqueConstraint(fields=("holder", "patient"), name="unique_memento"),
        ),
        migrations.AddConstraint(
            model_name="conversationarchive",
            constraint=models.UniqueConstraint(fields=("holder", "slug"), name="unique_conversationarchive_a"),
        ),
        migrations.AddConstraint(
            model_name="conversationarchive",
            constraint=models.UniqueConstraint(fields=("holder", "target"), name="unique_conversationarchive_b"),
        ),
        migrations.AddConstraint(
            model_name="conversation",
            constraint=models.UniqueConstraint(fields=("holder", "target"), name="unique_conversation"),
        ),
    ]
